/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.config2brigadier;

import com.google.gson.annotations.SerializedName;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.ApiStatus;
import org.samo_lego.config2brigadier.annotation.BrigadierDescription;
import org.samo_lego.config2brigadier.annotation.BrigadierExcluded;
import org.samo_lego.config2brigadier.command.CommandFeedback;
import org.samo_lego.config2brigadier.util.ConfigFieldList;
import org.samo_lego.config2brigadier.util.TranslatedText;

public interface IBrigadierConfigurator {
    public static final String COMMENT_PREFIX = "_comment_";

    public void save();

    default public void reload(Object newConfig) {
        this.recursiveReload(this, newConfig);
    }

    @ApiStatus.Internal
    default public void recursiveReload(Object config, Object newConfig) {
        try {
            for (Field field : config.getClass().getFields()) {
                Class<?> type = field.getType();
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                Object value = field.get(newConfig);
                if (type.isPrimitive() || type.equals(String.class) || type.equals(List.class)) {
                    field.set(config, value);
                    continue;
                }
                this.recursiveReload(field.get(config), value);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    default public String getDescription(Field field) {
        String name;
        Object description = "";
        if (field.isAnnotationPresent(BrigadierDescription.class)) {
            description = field.getAnnotation(BrigadierDescription.class).value();
        } else if (this.enableSerializedNameComments() && (name = field.getName()).startsWith(this.getCommentPrefix()) && field.isAnnotationPresent(SerializedName.class)) {
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            description = (String)description + serializedName.value().substring("// ".length());
        }
        return description;
    }

    default public boolean enableSerializedNameComments() {
        return true;
    }

    default public boolean shouldExclude(Field field) {
        return field.getName().startsWith(this.getCommentPrefix()) || field.isAnnotationPresent(BrigadierExcluded.class) || Modifier.isStatic(field.getModifiers());
    }

    default public String getCommentPrefix() {
        return COMMENT_PREFIX;
    }

    default public void generateCommand(LiteralCommandNode<class_2168> editNode) {
        ConfigFieldList configFields = ConfigFieldList.populateFields(null, this, this);
        this.recursiveEditCommand(editNode, configFields);
    }

    @ApiStatus.Internal
    default public void recursiveEditCommand(LiteralCommandNode<class_2168> root, ConfigFieldList configFields) {
        configFields.booleans().forEach(attribute -> {
            LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)attribute.getName()).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> CommandFeedback.editConfigBoolean((CommandContext<class_2168>)context, configFields.parent(), this, attribute)))).executes(context -> this.generateFieldInfo((CommandContext<class_2168>)context, configFields.parent(), (Field)attribute))).build();
            root.addChild((CommandNode)node);
        });
        configFields.integers().forEach(attribute -> {
            LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)attribute.getName()).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandFeedback.editConfigInt((CommandContext<class_2168>)context, configFields.parent(), this, attribute)))).executes(context -> this.generateFieldInfo((CommandContext<class_2168>)context, configFields.parent(), (Field)attribute))).build();
            root.addChild((CommandNode)node);
        });
        configFields.floats().forEach(attribute -> {
            LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)attribute.getName()).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> CommandFeedback.editConfigFloat((CommandContext<class_2168>)context, configFields.parent(), this, attribute)))).executes(context -> this.generateFieldInfo((CommandContext<class_2168>)context, configFields.parent(), (Field)attribute))).build();
            root.addChild((CommandNode)node);
        });
        configFields.doubles().forEach(attribute -> {
            LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)attribute.getName()).then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> CommandFeedback.editConfigDouble((CommandContext<class_2168>)context, configFields.parent(), this, attribute)))).executes(context -> this.generateFieldInfo((CommandContext<class_2168>)context, configFields.parent(), (Field)attribute))).build();
            root.addChild((CommandNode)node);
        });
        configFields.objects().forEach(attribute -> {
            LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)attribute.getName()).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandFeedback.editConfigObject((CommandContext<class_2168>)context, configFields.parent(), this, attribute)))).executes(context -> this.generateFieldInfo((CommandContext<class_2168>)context, configFields.parent(), (Field)attribute))).build();
            root.addChild((CommandNode)node);
        });
        configFields.nestedFields().forEach(generator -> {
            Field parentField = generator.parentField();
            String nodeName = parentField == null ? root.getName() : parentField.getName();
            LiteralCommandNode node = ((LiteralArgumentBuilder)class_2170.method_9247((String)nodeName).executes(context -> {
                if (parentField != null) {
                    return this.generateFieldInfo((CommandContext<class_2168>)context, configFields.parent(), parentField);
                }
                return -1;
            })).build();
            this.recursiveEditCommand((LiteralCommandNode<class_2168>)node, (ConfigFieldList)generator);
            root.addChild((CommandNode)node);
        });
    }

    default public class_5250 generateFieldDescription(Object parent, Field attribute) {
        Field[] fields;
        List<Field> descriptionList;
        int size;
        class_2585 textFeedback = new class_2585("");
        String attributeName = attribute.getName();
        String fieldDescription = this.getDescription(attribute);
        boolean emptyBrigadierDesc = fieldDescription.isEmpty();
        if (!emptyBrigadierDesc) {
            textFeedback.method_10852((class_2561)new class_2588(fieldDescription));
        }
        if ((size = (descriptionList = Arrays.stream(fields = parent.getClass().getFields()).filter(field -> {
            String name = field.getName();
            return name.contains(attributeName);
        }).collect(Collectors.toList())).size() - 1) > 0) {
            String[] sortedDescriptions = new String[size];
            descriptionList.forEach(field -> {
                int index = NumberUtils.toInt((String)field.getName().replaceAll("\\D+", ""), (int)0);
                String description = this.getDescription((Field)field);
                if (!description.isEmpty()) {
                    sortedDescriptions[index] = description;
                }
            });
            for (int i = 0; i < sortedDescriptions.length; ++i) {
                String desc = sortedDescriptions[i];
                if (i == 0 && emptyBrigadierDesc) {
                    textFeedback.method_10852((class_2561)new class_2585(desc));
                    continue;
                }
                textFeedback.method_10852((class_2561)new class_2585("\n").method_27693(desc));
            }
        }
        if (textFeedback.method_10855().isEmpty()) {
            class_5250 feedback = new TranslatedText("config2brigadier.command.edit.no_description_found", attributeName).method_27692(class_124.field_1076);
            textFeedback.method_10852((class_2561)feedback);
        }
        return textFeedback;
    }

    @ApiStatus.Internal
    default public int generateFieldInfo(CommandContext<class_2168> context, Object parent, Field attribute) {
        class_5250 fieldDesc = new class_2585("").method_10852((class_2561)this.generateFieldDescription(parent, attribute).method_27692(class_124.field_1056));
        fieldDesc.method_27692(class_124.field_1070);
        String defaultOption = "";
        if (attribute.isAnnotationPresent(BrigadierDescription.class) && !(defaultOption = attribute.getAnnotation(BrigadierDescription.class).defaultOption()).isEmpty()) {
            String finalDefaultOption = defaultOption;
            class_5250 defaultValueComponent = new class_2585(defaultOption).method_27692(class_124.field_1077).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(finalDefaultOption))).method_10958(new class_2558(class_2558.class_2559.field_11745, finalDefaultOption)));
            fieldDesc.method_27693("\n").method_10852((class_2561)new TranslatedText("editGamerule.default", defaultValueComponent).method_27692(class_124.field_1080));
        }
        try {
            Object val = attribute.get(parent);
            String value = val.toString();
            if (!attribute.getType().isMemberClass()) {
                class_5250 valueComponent = new class_2585(value).method_27692(class_124.field_1060).method_27692(class_124.field_1067).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(value))).method_10958(new class_2558(class_2558.class_2559.field_11745, value)));
                if (!defaultOption.isEmpty() && !defaultOption.equals(value)) {
                    valueComponent.method_10852((class_2561)new class_2585(" (*)").method_27692(class_124.field_1054));
                }
                fieldDesc.method_27693("\n").method_10852((class_2561)new class_2588("options.fullscreen.current").method_27693(": ").method_10852((class_2561)valueComponent).method_27692(class_124.field_1080));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (!attribute.getType().isMemberClass()) {
            class_5250 type = new class_2585(attribute.getType().getSimpleName()).method_27692(class_124.field_1075);
            fieldDesc.method_27693("\n").method_10852((class_2561)new TranslatedText("gui.entity_tooltip.type", type).method_27692(class_124.field_1080));
        }
        ((class_2168)context.getSource()).method_9226((class_2561)fieldDesc.method_27692(class_124.field_1065), false);
        return 1;
    }
}

